/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.security.AccessController;
import java.util.List;
import java.util.Vector;
import sun.awt.shell.ShellFolderManager;
import sun.security.action.GetPropertyAction;

public abstract class ShellFolder
extends File {
    private static boolean disableFileChooserSpeedFixProperty;
    protected ShellFolder parent;
    private static ShellFolderManager shellFolderManager;
    static Class class$sun$awt$shell$ShellFolderManager;

    public long lastModified() {
        return this.isFileSystem() ? super.lastModified() : 0L;
    }

    public long length() {
        return this.isFileSystem() ? super.length() : 0L;
    }

    static {
        Object object = (String)AccessController.doPrivileged(new GetPropertyAction("swing.disableFileChooserSpeedFix"));
        disableFileChooserSpeedFixProperty = object != null && !((String)object).equalsIgnoreCase("false");
        object = (Class)Toolkit.getDefaultToolkit().getDesktopProperty("Shell.shellFolderManager");
        if (object == null) {
            object = class$sun$awt$shell$ShellFolderManager == null ? (class$sun$awt$shell$ShellFolderManager = ShellFolder.class$("sun.awt.shell.ShellFolderManager")) : class$sun$awt$shell$ShellFolderManager;
        }
        try {
            shellFolderManager = (ShellFolderManager)((Class)object).newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new Error("Could not instantiate Shell Folder Manager: " + ((Class)object).getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Could not access Shell Folder Manager: " + ((Class)object).getName());
        }
    }

    public void deleteOnExit() {
        if (this.isFileSystem()) {
            super.deleteOnExit();
        }
    }

    public boolean canRead() {
        return this.isFileSystem() ? super.canRead() : true;
    }

    public boolean canWrite() {
        return this.isFileSystem() ? super.canWrite() : false;
    }

    public boolean createNewFile() throws IOException {
        return this.isFileSystem() ? super.createNewFile() : false;
    }

    public boolean delete() {
        return this.isFileSystem() ? super.delete() : false;
    }

    public static boolean disableFileChooserSpeedFix() {
        return disableFileChooserSpeedFixProperty;
    }

    public boolean exists() {
        return !this.isFileSystem() || ShellFolder.isFileSystemRoot(this) || super.exists();
    }

    public boolean isAbsolute() {
        return !this.isFileSystem() || super.isAbsolute();
    }

    public boolean isDirectory() {
        return this.isFileSystem() ? super.isDirectory() : true;
    }

    public boolean isFile() {
        return this.isFileSystem() ? super.isFile() : !this.isDirectory();
    }

    public boolean isFileSystem() {
        return !this.getPath().startsWith("ShellFolder");
    }

    public abstract boolean isLink();

    public boolean mkdir() {
        return this.isFileSystem() ? super.mkdir() : false;
    }

    public boolean mkdirs() {
        return this.isFileSystem() ? super.mkdirs() : false;
    }

    public boolean setReadOnly() {
        return this.isFileSystem() ? super.setReadOnly() : false;
    }

    public boolean setLastModified(long l2) {
        return this.isFileSystem() ? super.setLastModified(l2) : false;
    }

    public Image getIcon(boolean bl2) {
        return null;
    }

    public File getAbsoluteFile() {
        return this.isFileSystem() ? super.getAbsoluteFile() : this;
    }

    public File getParentFile() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isFileSystem()) {
            return super.getParentFile();
        }
        return null;
    }

    public File[] listFiles() {
        return this.listFiles(true);
    }

    public int compareTo(File file) {
        if (file == null || !(file instanceof ShellFolder) || file instanceof ShellFolder && ((ShellFolder)file).isFileSystem()) {
            if (this.isFileSystem()) {
                return super.compareTo(file);
            }
            return -1;
        }
        if (this.isFileSystem()) {
            return 1;
        }
        return this.getName().compareTo(file.getName());
    }

    public static boolean isComputerNode(File file) {
        return shellFolderManager.isComputerNode(file);
    }

    public static boolean isFileSystemRoot(File file) {
        return shellFolderManager.isFileSystemRoot(file);
    }

    public boolean renameTo(File file) {
        return this.isFileSystem() ? super.renameTo(file) : false;
    }

    public File[] listFiles(boolean bl2) {
        File[] fileArray = super.listFiles();
        if (!bl2) {
            Vector vector = new Vector();
            int n2 = fileArray == null ? 0 : fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (fileArray[i2].isHidden()) continue;
                vector.addElement(fileArray[i2]);
            }
            fileArray = (File[])vector.toArray(new File[vector.size()]);
        }
        return fileArray;
    }

    protected abstract Object writeReplace() throws ObjectStreamException;

    public int compareTo(Object object) {
        return this.compareTo((File)object);
    }

    public abstract String getDisplayName();

    public abstract String getExecutableType();

    public abstract String getFolderType();

    public String getParent() {
        if (this.parent == null && this.isFileSystem()) {
            return super.getParent();
        }
        if (this.parent != null) {
            return this.parent.getPath();
        }
        return null;
    }

    public String toString() {
        return this.isFileSystem() ? super.toString() : this.getDisplayName();
    }

    public static void sortFiles(List list) {
        shellFolderManager.sortFiles(list);
    }

    public abstract ShellFolder getLinkLocation() throws FileNotFoundException;

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static Object get(String string) {
        return shellFolderManager.get(string);
    }

    ShellFolder(ShellFolder shellFolder, String string) {
        super(string != null ? string : "ShellFolder");
        this.parent = shellFolder;
    }

    public static ShellFolder getShellFolder(File file) throws FileNotFoundException {
        if (file instanceof ShellFolder) {
            return (ShellFolder)file;
        }
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        return shellFolderManager.createShellFolder(file);
    }
}

